gDlg = null;		// dialog iframe element
gDlgWin = null;		// dialog iframe window
gCurPage = null;	// Current sequence map item

gMinDlgHeight = 495; // min dlg iframe height before scrolling is turned on


//-----------------------------------------------------------------------------------------------
function main()
	// Initialize the page when loaded
{
	gDlg = document.getElementById("dlg");
	gDlgWin = frames[0];
	
	SetupSequenceMap();
	
	onNext();
	//gDlg.style.visibility = "visible";
}

//-----------------------------------------------------------------------------------------------
function onNext(id)
	// Handle dialog page transition
{
	if(!gDlgWin) return;
	
	var bOrigStyle = gDlgWin.document.body.style.visibility;
	gDlgWin.document.body.style.visibility = "hidden";
		// Hide the body of the page to avoid reclicks
	
	saveDlgData(gDlgWin);
		// Update the data source with the values on the dialog
	
	if( "back"!=id && gDlgWin.isDlgValid && !gDlgWin.isDlgValid() )
	{
		window.scrollTo(0,0);
		gDlgWin.document.body.style.visibility = bOrigStyle;
		return;
		// validate the data on the page if the validate function is present
	}
				
	runToNext(id);
}

//-----------------------------------------------------------------------------------------------
function runToNext(id)
	// Run to the next item in the sequence map
{
	var nextPage = gSequenceMap.runToNext( gCurPage, id );
	if( kUnknownID!=nextPage )
	{
		window.scrollTo(0,0);
			
		gCurPage = nextPage;
		if(gDlgWin) gDlgWin.location.href = nextPage;
			// Load in the next dialog page
	}	
	else
	{	
		if(gDlgWin) gDlgWin.document.body.style.visibility = "visible";
		// on same page...show again
	}
}

//-----------------------------------------------------------------------------------------------
function runAct(action)
	// Callback from zSequenceMap::runToNext to run the action identified by the specified id
{
	var s = "gDlgWin." + action + "()";
	return result = eval( s ); 	
}


//-----------------------------------------------------------------------------------------------
function onDlgLoad()
	// Handler the load of the dialog page by exchanging data
{
	// get the page name and set it as the current page, gCurPage,
	// in case the browser back accelerator key was used 
	if( gDlgWin && gDlgWin.location )
	{
		var fn=gDlgWin.location.pathname;

		var pos=fn.lastIndexOf('\\');
		if( pos<0 ) pos=fn.lastIndexOf('/');

		if( pos<0 )gCurPage = fn;
		else gCurPage = fn.substr(pos+1);
		
		// Append the query string, to enable uniqueness within
		// the sequence map
		if( gDlgWin.location.search.length > 0 ) gCurPage += gDlgWin.location.search;
	}

	initDlgData(gDlgWin);
}

//-----------------------------------------------------------------------------------------------
function onPrint()
	// Print the contents of this window
{
	window.print();
}

//-----------------------------------------------------------------------------------------------
// Setup
//-----------------------------------------------------------------------------------------------

function SetupSequenceMap()
{
	gSequenceMap = new zSequenceMap( runAct, new Array(
	// Defines the path through the sequence of dialogs

	// ***************************************************
	// Check for Availability of state(s)/patches process
	// ***************************************************
	
	// Display checking for availability screen for state(s) and/or patches
	new zTransitionMap( "updateMgrConnecting.htm", new Array(
		new zTransitionMapItem( "next", null, "initUpdateMgrConnecting" )		
	)),
	
	new zTransitionMap( "initUpdateMgrConnecting", new Array(
		new zTransitionMapItem( "yes", null, "actIsInstallPatchOnly"),
		new zTransitionMapItem( "failed", null, "actExit")
	)),
	
	new zTransitionMap( "actIsInstallPatchOnly", new Array(
		new zTransitionMapItem( "yes", null, "actIsAnythingToInstall" ),
		new zTransitionMapItem( "no", null, "actIsDownloadXMLOnly" )
	)),

	// Determine if download FormsAvailXML file only
	new zTransitionMap( "actIsDownloadXMLOnly", new Array(
		new zTransitionMapItem( "yes", null, "actGetFormsAvailability" ),
		new zTransitionMapItem( "no", null, "actIsGetUpdatesOnly" )
	)),

	// Download FormsAvail.xml file only and exit
	new zTransitionMap( "actGetFormsAvailability", new Array(
		new zTransitionMapItem( "ok", null, "actExit" )
	)),

	// Determine if get updates only or do the normal process
	new zTransitionMap( "actIsGetUpdatesOnly", new Array(		
		new zTransitionMapItem( "yes", null, "actGetPatchAvailability" ),
		new zTransitionMapItem( "no", null, "actIsStateInvolvedForAvailabilityCheck" )
	)),

	// Determine if a state is involved when checking for patch availability
	new zTransitionMap( "actIsStateInvolvedForAvailabilityCheck", new Array(
		new zTransitionMapItem( "yes", null, "actGetStateAvailability" ),
		new zTransitionMapItem( "no", null, "actGetPatchAvailability" )
	)),
	
	// Download FSA report to check availability for states.
	// Regardless of failure, continue to check for patches.
	new zTransitionMap( "actGetStateAvailability", new Array(
		new zTransitionMapItem( "ok", null, "actGetPatchAvailability" ),
		new zTransitionMapItem( "failed", null, "actGetPatchAvailability" )		
	)),

	// Check availability for patches
	new zTransitionMap( "actGetPatchAvailability", new Array(
		new zTransitionMapItem( "ok", null, "actIsAnythingToDownloadAndInstall" ),
		new zTransitionMapItem( "failed", null, "actExit" )
	)),
	
	// Anything to download or to install?	
	new zTransitionMap( "actIsAnythingToDownloadAndInstall", new Array(				
		new zTransitionMapItem( "yes", null, "actIsAnyStateToDownload" ),
		new zTransitionMapItem( "no", "updateMgrStatus.htm?noInstall.htm" )
	)),

	// Any states to download? This includes existing files on the system.	
	new zTransitionMap( "actIsAnyStateToDownload", new Array(		
		new zTransitionMapItem( "yes", "updateMgrStateDownloading.htm" ),
		new zTransitionMapItem( "no", null, "actIsAnyPatchToDownload" )
	)),

	// Any patches to download? This includes existing files on the system.	
	new zTransitionMap( "actIsAnyPatchToDownload", new Array(		
		new zTransitionMapItem( "yes", "updateMgrPatchDownloading.htm" ),		
		new zTransitionMapItem( "no",  null, "actIsAnythingToInstall" )
	)),

	// Anything to install? This includes existing files on the system for
	// both state(s) and patches.
	new zTransitionMap( "actIsAnythingToInstall", new Array(		
		new zTransitionMapItem( "yes", "updateMgrInstalling.htm" ),
		new zTransitionMapItem( "no", null, "actIsAnyErrors" )
	)),

	// Any errors to display before the app. exits?
	new zTransitionMap( "actIsAnyErrors", new Array(		
		new zTransitionMapItem( "yes", "updateMgrStatus.htm?noInstall.htm" ),
		new zTransitionMapItem( "no",  "updateMgrStatus.htm?noInstall.htm" )
	)),

	// ***************************************************
	// Download and Status process
	// ***************************************************

	// State downloading screen
	new zTransitionMap( "updateMgrStateDownloading.htm", new Array(		
		new zTransitionMapItem( "next", null, "actStateDownload" )	
	)),

    // Regardless of failure, continue with downloading patches.
	new zTransitionMap( "actStateDownload", new Array(		
		new zTransitionMapItem( "ok", null, "actIsAnyPatchToDownload" ),
		new zTransitionMapItem( "failed", null, "actIsAnyPatchToDownload" )
	)),

	// Patch downloading screen
	new zTransitionMap( "updateMgrPatchDownloading.htm", new Array(		
		new zTransitionMapItem( "next", null, "actPatchDownload" )	
	)),

	new zTransitionMap( "actPatchDownload", new Array(		
		new zTransitionMapItem( "ok", null, "actIsAnythingToInstall" ), 
		new zTransitionMapItem( "failed",  null, "actExit")
	)),	

	// ***************************************************
	// Install process
	// ***************************************************

	// Status screen with Install button
//	new zTransitionMap( "updateMgrStatus.htm", new Array(		
//		new zTransitionMapItem( "yes", "updateMgrInstallWait.htm" )
//	)),

//	new zTransitionMap( "updateMgrInstallWait.htm", new Array(		
//		new zTransitionMapItem( "next", null, "actInstallNow" )  // install and exit
//	)),

	new zTransitionMap( "updateMgrInstalling.htm", new Array(		
		new zTransitionMapItem( "next", null, "actInstallNow" )  // install patch & states
	)),

	new zTransitionMap( "actInstallNow", new Array(		
		new zTransitionMapItem( "ok", "updateMgrStatus.htm" ),
		new zTransitionMapItem( "failed",  null, "actExit")
	)),

	new zTransitionMap( "updateMgrStatus.htm", new Array(		
		new zTransitionMapItem( "yes", null, "actLaunchTurboTax" )
	)),

	new zTransitionMap( "actLaunchTurboTax", new Array(		
		new zTransitionMapItem( "ok", null, "actExit" )
	)),

	// Status screen with nothing to install
	new zTransitionMap( "updateMgrStatus.htm?noInstall.htm", new Array(		
		new zTransitionMapItem( "next", null, "actExit" )
	))
));

}	